// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Indnscommon.pas' rev: 10.00

#ifndef IndnscommonHPP
#define IndnscommonHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Inglobal.hpp>	// Pascal unit
#include <Inresourcestringsprotocols.hpp>	// Pascal unit
#include <Inexception.hpp>	// Pascal unit
#include <Inresourcestrings.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Indnscommon
{
//-- type declarations -------------------------------------------------------
typedef AnsiString InDNSCommon__1[6];

#pragma option push -b-
enum TDNSQueryRecordTypes { DqtA, DqtNS, DqtMD, DqtMF, DqtName, DqtSOA, DqtMB, DqtMG, DqtMR, DqtNull, DqtWKS, DqtPTR, DqtHINFO, DqtMINFO, DqtMX, DqtTXT, DqtNSAP, DqtNSAP_PTR, DqtLOC, DqtAXFR, DqtSTAR, DqtAAAA };
#pragma option pop

#pragma option push -b-
enum TDNSServerTypes { stPrimary, stSecondary };
#pragma option pop

class DELPHICLASS EInDNSServerSyncException;
class PASCALIMPLEMENTATION EInDNSServerSyncException : public Inexception::EIdSilentException 
{
	typedef Inexception::EIdSilentException inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInDNSServerSyncException(AnsiString AMsg)/* overload */ : Inexception::EIdSilentException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInDNSServerSyncException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Inexception::EIdSilentException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInDNSServerSyncException(int Ident)/* overload */ : Inexception::EIdSilentException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInDNSServerSyncException(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Inexception::EIdSilentException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInDNSServerSyncException(const AnsiString Msg, int AHelpContext) : Inexception::EIdSilentException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInDNSServerSyncException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Inexception::EIdSilentException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInDNSServerSyncException(int Ident, int AHelpContext)/* overload */ : Inexception::EIdSilentException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInDNSServerSyncException(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Inexception::EIdSilentException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInDNSServerSyncException(void) { }
	#pragma option pop
	
};


class DELPHICLASS EInDNSServerSettingException;
class PASCALIMPLEMENTATION EInDNSServerSettingException : public Inexception::EIdSilentException 
{
	typedef Inexception::EIdSilentException inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInDNSServerSettingException(AnsiString AMsg)/* overload */ : Inexception::EIdSilentException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInDNSServerSettingException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Inexception::EIdSilentException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInDNSServerSettingException(int Ident)/* overload */ : Inexception::EIdSilentException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInDNSServerSettingException(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Inexception::EIdSilentException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInDNSServerSettingException(const AnsiString Msg, int AHelpContext) : Inexception::EIdSilentException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInDNSServerSettingException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Inexception::EIdSilentException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInDNSServerSettingException(int Ident, int AHelpContext)/* overload */ : Inexception::EIdSilentException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInDNSServerSettingException(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Inexception::EIdSilentException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInDNSServerSettingException(void) { }
	#pragma option pop
	
};


class DELPHICLASS TDNSHeader;
class PASCALIMPLEMENTATION TDNSHeader : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Word FID;
	Word FBitCode;
	Word FQDCount;
	Word FANCount;
	Word FNSCount;
	Word FARCount;
	Word __fastcall GetAA(void);
	Word __fastcall GetOpCode(void);
	Word __fastcall GetQr(void);
	Word __fastcall GetRA(void);
	Word __fastcall GetRCode(void);
	Word __fastcall GetRD(void);
	Word __fastcall GetTC(void);
	void __fastcall SetAA(const Word Value);
	void __fastcall SetOpCode(const Word Value);
	void __fastcall SetQr(const Word Value);
	void __fastcall SetRA(const Word Value);
	void __fastcall SetRCode(const Word Value);
	void __fastcall SetRD(const Word Value);
	void __fastcall SetTC(const Word Value);
	void __fastcall SetBitCode(const Word Value);
	
public:
	__fastcall TDNSHeader(void);
	void __fastcall ClearByteCode(void);
	int __fastcall ParseQuery(Inglobal::TBytes Data);
	Inglobal::TBytes __fastcall GenerateBinaryHeader();
	__property Word ID = {read=FID, write=FID, nodefault};
	__property Word Qr = {read=GetQr, write=SetQr, nodefault};
	__property Word OpCode = {read=GetOpCode, write=SetOpCode, nodefault};
	__property Word AA = {read=GetAA, write=SetAA, nodefault};
	__property Word TC = {read=GetTC, write=SetTC, nodefault};
	__property Word RD = {read=GetRD, write=SetRD, nodefault};
	__property Word RA = {read=GetRA, write=SetRA, nodefault};
	__property Word RCode = {read=GetRCode, write=SetRCode, nodefault};
	__property Word BitCode = {read=FBitCode, write=SetBitCode, nodefault};
	__property Word QDCount = {read=FQDCount, write=FQDCount, nodefault};
	__property Word ANCount = {read=FANCount, write=FANCount, nodefault};
	__property Word NSCount = {read=FNSCount, write=FNSCount, nodefault};
	__property Word ARCount = {read=FARCount, write=FARCount, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TDNSHeader(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
static const Shortint cRCodeNoError = 0x0;
static const Shortint cRCodeFormatErr = 0x1;
static const Shortint cRCodeServerErr = 0x2;
static const Shortint cRCodeNameErr = 0x3;
static const Shortint cRCodeNotImplemented = 0x4;
static const Shortint cRCodeRefused = 0x5;
static const Shortint iRCodeQueryNotImplement = 0x0;
static const Shortint iRCodeQueryReturned = 0x1;
static const Shortint iRCodeQueryOK = 0x2;
static const Shortint iRCodeQueryNotFound = 0x3;
static const Shortint iRCodeNoError = 0x0;
static const Shortint iRCodeFormatError = 0x1;
static const Shortint iRCodeServerFailure = 0x2;
static const Shortint iRCodeNameError = 0x3;
static const Shortint iRCodeNotImplemented = 0x4;
static const Shortint iRCodeRefused = 0x5;
static const Shortint iQr_Question = 0x0;
static const Shortint iQr_Answer = 0x1;
static const Shortint iAA_NotAuthoritative = 0x0;
static const Shortint iAA_Authoritative = 0x1;
#define cRCodeQueryNotImplement "NA"
#define cRCodeQueryReturned "RC"
#define cRCodeQueryOK "OK"
#define cRCodeQueryCacheOK "COK"
#define cRCodeQueryNotFound "NOTFOUND"
#define RSDNSServerAXFRError_QuerySequenceError "First record must be SOA!"
#define RSDNSServerSettingError_MappingHostError "Host must be an IP address"
#define cOrigin "$ORIGIN"
#define cInclude "$INCLUDE"
#define cAAAA "AAAA"
static const char cAt = '\x40';
static const char cA = '\x41';
#define cNS "NS"
#define cMD "MD"
#define cMF "MF"
#define cCName "CNAME"
#define cSOA "SOA"
#define cMB "MB"
#define cMG "MG"
#define cMR "MR"
#define cNULL "NULL"
#define cWKS "WKS"
#define cPTR "PTR"
#define cHINFO "HINFO"
#define cMINFO "MINFO"
#define cMX "MX"
#define cTXT "TXT"
#define cNSAP "NSAP"
#define cNSAP_PTR "NSAP-PTR"
#define cLOC "LOC"
#define cAXFR "AXFR"
#define cSTAR "STAR"
extern PACKAGE AnsiString cRCodeStrs[6];
static const Shortint Class_IN = 0x1;
static const Shortint TypeCode_A = 0x1;
static const Shortint TypeCode_NS = 0x2;
static const Shortint TypeCode_MD = 0x3;
static const Shortint TypeCode_MF = 0x4;
static const Shortint TypeCode_CName = 0x5;
static const Shortint TypeCode_SOA = 0x6;
static const Shortint TypeCode_MB = 0x7;
static const Shortint TypeCode_MG = 0x8;
static const Shortint TypeCode_MR = 0x9;
static const Shortint TypeCode_NULL = 0xa;
static const Shortint TypeCode_WKS = 0xb;
static const Shortint TypeCode_PTR = 0xc;
static const Shortint TypeCode_HINFO = 0xd;
static const Shortint TypeCode_MINFO = 0xe;
static const Shortint TypeCode_MX = 0xf;
static const Shortint TypeCode_TXT = 0x10;
static const Shortint TypeCode_NSAP = 0x16;
static const Shortint TypeCode_NSAP_PTR = 0x17;
static const Shortint TypeCode_AAAA = 0x1c;
static const Shortint TypeCode_LOC = 0x1d;
static const Byte TypeCode_AXFR = 0xfc;
static const Byte TypeCode_STAR = 0xff;
extern PACKAGE Inglobal::TBytes __fastcall DomainNameToDNSStr(AnsiString ADomain);
extern PACKAGE Inglobal::TBytes __fastcall NormalStrToDNSStr(AnsiString Str);
extern PACKAGE Inglobal::TBytes __fastcall IPAddrToDNSStr(AnsiString IPAddress);
extern PACKAGE Inglobal::TBytes __fastcall IPv6AAAAToDNSStr(AnsiString IPv6Address);
extern PACKAGE bool __fastcall IsValidIPv6(AnsiString v6Address);
extern PACKAGE AnsiString __fastcall ConvertToVaildv6IP(AnsiString OrgIP);
extern PACKAGE AnsiString __fastcall ConvertToCanonical6IP(AnsiString OrgIP);
extern PACKAGE AnsiString __fastcall GetErrorStr(int Code, int Id);
extern PACKAGE AnsiString __fastcall GetRCodeStr(int RCode);
extern PACKAGE AnsiString __fastcall ReplaceSpecString(AnsiString Source, AnsiString Target, AnsiString NewString, bool ReplaceAll = true);
extern PACKAGE bool __fastcall IsBig5(char ch1, char ch2);

}	/* namespace Indnscommon */
using namespace Indnscommon;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Indnscommon
